import {ISettlementInfo} from '../common/ISettlementInfo';
import {IFromPoint} from '../common/IFromPoint';
import {EColor} from '../seo-pages/flight/models';
import {IGetCountryRestrictionsExtendedMetric} from '../country-restrictions/v1/response';
import {ILinguistics} from '../../common/common';

export interface IRestrictions {
    color: EColor;
    titleText: string;
    expandedBannerMetrics: IGetCountryRestrictionsExtendedMetric[];
}

export interface ISettlementInfoForSearchToWherePossible
    extends ISettlementInfo {
    countryTitle: ILinguistics;
}

export interface IPoint {
    settlementInfo: ISettlementInfoForSearchToWherePossible;
    restrictions: IRestrictions;
}

export interface IResultGroup {
    /**
     * Название блока стран.
     * @example 'По России', 'За границу без пересадок'
     */
    title: string;
    points: IPoint[];
}

export interface IWherePossibleResponse {
    fromPoint: IFromPoint;
    settlements: IResultGroup[];
}
