import {IFare} from 'travel/orders/generic-booking-flow/bus-service';
import EDocumentType from 'common/EDocumentType';
import {EGender} from 'common/common';
import {IAffiliateAttribution} from 'common/IAffiliateAttribution';

enum ETicketType {
    FULL = 'FULL',
    CHILD = 'CHILD',
    BAGGAGE = 'BAGGAGE',
}

interface ITicketType {
    type: ETicketType;
    fare: IFare;
}

enum EPlaceType {
    DRIVER = 'DRIVER',
    SEAT = 'SEAT',
    PASSAGE = 'PASSAGE',
}

enum EPlaceStatus {
    FREE = 'FREE',
    OCCUPIED = 'OCCUPIED',
}

interface IPlace {
    id: string;
    x: number;
    y: number;
    type: EPlaceType;
    status: EPlaceStatus;
}

export interface IBookParams {
    documentTypes: EDocumentType[];
    ticketTypes: ITicketType[];
    genders: EGender[];
    seats: string[];
    placesMap: IPlace[];
    citizenships: string[];
}

/**
 * Метаинформация для создания оффера
 * https://a.yandex-team.ru/arc_vcs/travel/proto/buses/label_params.proto
 */
export interface IBusesLabelParams extends IAffiliateAttribution {
    serpReqId?: string;
    utmSource?: string;
    utmMedium?: string;
    utmCampaign?: string;
    utmTerm?: string;
    utmContent?: string;
    from?: string;
    gclid?: string;
    icookie?: string;
    serpUuid?: string;
    testBuckets?: string;
    device: string;
    terminal: string;
    ip?: string;
    regionId?: number;
    uid?: string;
    yandexUid?: string;
    wizardReqId?: string;
    serpTestId?: string;
    ytpReferer?: string;
    yclid?: string;
    fbclid?: string;
    metrikaClientId?: string;
}
