import {
    ICoordinates,
    ILinguistics,
    IPrice,
    TLocalDateTime,
} from 'common/common';
import {TSlug} from 'common/PointKey';

enum ESearchError {
    COMMON = 'common',
    /** Пункт отправления/прибытия не найден. */
    POINT_NOT_FOUND = 'point_not_found',
    SAME_POINTS = 'same_points',
}

interface IContextPointCountry {
    code: string;
    title: string;
}

/**
 * Полная информация о пункте отправления/прибытия.
 */
interface IContextPoint {
    country: IContextPointCountry;
    key: string;
    region: {title: string};
    settlement: {title: string};
    slug: string;
    timezone: string;
    title: Pick<
        ILinguistics,
        'accusativeCase' | 'genitiveCase' | 'nominativeCase' | 'locativeCase'
    >;
}

export interface IBusesContext {
    when?: string;

    /** Информация о пункте отправления. */
    from: IContextPoint;

    /** Информация о пункте прибытия. */
    to: IContextPoint;

    /**
     * Дистанция между пунктами в км.
     * Не приходит для поиска внутри города, например moscow--moscow-yaroslavskaya
     */
    distance?: number;

    errors: ESearchError[];
}

interface IBusesApiPoint {
    /**
     * @example "Воронеж, трасса М4"
     * @example "авт.ост. Воронеж, трасса М4, г. Воронеж, Воронежская область, Россия
     */
    title: string;
    /**
     * Полное именование станции - отображается в модале с детальной информацией о станции
     * Не приходит когда нет информации о точке с ее координатами (тогда мы не показываем модал с картой)
     * @example "авт.вкз. Великий Новгород, г. Великий Новгород, Новгородская область, Россия"
     */
    fullTitle?: string;
    /** @example "Europe/Moscow" */
    timezone: string;
    coordinates?: ICoordinates;
}

export interface IBusesSegment {
    id: string;
    carrierCode: string;
    carrierName?: string;
    arrivalTime?: TLocalDateTime;
    departureTime: TLocalDateTime;
    duration?: number;
    freeSeats: number;
    price: IPrice;
    from: IBusesApiPoint;
    to: IBusesApiPoint;
}

export interface ICrossLink {
    toKey: string;
    toSlug: TSlug;
    toTitle: string;
    fromKey: string;
    fromSlug: TSlug;
    fromTitle: string;
}
