import {TDate} from 'common/common';
import {ICrossSaleHotelsBlock} from 'common/seo-pages/ICrossSaleHotelsBlock';

import {IBusesSegment, IBusesContext, ICrossLink} from './models';

enum EBusesDirectionBlock {
    BUSES_CROSSLINK = 'IBusesCrossLinksBlock',
    BUSES_SEGMENTS = 'IBusesSegmentsBlock',
}

interface IBusesCrossLinksData {
    title?: string;
    crossLinks: ICrossLink[];
}

interface IBusesCrossLinksBlock {
    type: EBusesDirectionBlock.BUSES_CROSSLINK;
    data: IBusesCrossLinksData;
}

interface IBusesSegmentsData {
    title?: string;
    /** Дата на которую были найдены сегменты, отсутствует при отсутствии сегментов в поиске */
    when?: TDate;
    segments: IBusesSegment[];
}

interface IBusesSegmentsBlock {
    type: EBusesDirectionBlock.BUSES_SEGMENTS;
    data: IBusesSegmentsData;
}

type TDirectionPageBlock =
    | IBusesSegmentsBlock
    | IBusesCrossLinksBlock
    | ICrossSaleHotelsBlock;

interface IDirectionResponse {
    context: IBusesContext;
    blocks: TDirectionPageBlock[];
}

interface IErrorResponse {
    error: string;
}

export type TResponse = IDirectionResponse | IErrorResponse;
