/**
 * Описание PointKey (уникальные id для объектов) для стран, городов и станций
 */

/**
 * Идентификатор страны.
 * Строка с префиксом 'l'. Например 'l52'.
 */
export type TCountryKey = string;

/**
 * Идентификатор региона.
 * Строка с префиксом 'r'. Например 'r977'.
 */
export type TRegionKey = string;

/**
 * Идентификатор населенного пункта.
 * Строка с префиксом 'c'. Например 'c52'.
 */
export type TSettlementKey = string;

/**
 * Идентификатор станции.
 * Строка с префиксом 's'. Например 's1084'.
 */
export type TStationKey = string;

/**
 * Идентификатор любой геоточки.
 */
export type TPointKey = TStationKey | TSettlementKey | TRegionKey | TCountryKey;

/**
 * Человекочитаемые уникальные идентификаторы станций, населенных пунктов и стран.
 * Может содержать буквы латинского алфавита, цифры и тире.
 *
 * @example 'moscow'.
 */
export type TSlug = string;
