export interface ITextElementData {
    text: string;
}

export interface IUrlElementData {
    text: string;
    url: string;
}

export enum ERichStringBlockType {
    TEXT = 'text',
    URL = 'url',
}

export interface IRichStringBlock<TypeElement, DataElement> {
    blockType: TypeElement;
    data: DataElement;
}

export type TRichStringBlockVariants =
    | IRichStringBlock<ERichStringBlockType.TEXT, ITextElementData>
    | IRichStringBlock<ERichStringBlockType.URL, IUrlElementData>;

export type TRichStringBlockList = TRichStringBlockVariants[];

export interface IRichString {
    data: TRichStringBlockList;
}
