/** *****************************************************************************/
/* Общие скалярные типы. */
/** *****************************************************************************/

/**
 * Инстант - Абсолютный момент времени, определяющий дату и время
 * Передается в формате ISO 8601 (YYYY-MM-DDThh:mm:ssZ)
 * Время указано в UTC
 */
export type TInstantDateTime = string;

/**
 * Дата и время в формате ISO 8601 (YYYY-MM-DDThh:mm:ss)
 */
export type TLocalDateTime = string;

/**
 * Дата
 * Кодируется в формате YYYY-MM-DD
 */
export type TDate = string;

/**
 * UUID
 * используется преимущественно для идентификаторов
 */
export type TUuid = string;

/** Целочисленное значение */
export type TInteger = number;

/** Целочисленное значение (64 bit) */
export type TLong = string;

/** Число с плавающей запятой */
export type TFloat = number;

export type TUrl = string;

/** *****************************************************************************/
/* Общие структурные типы. */
/** *****************************************************************************/

/**
 * Географические координаты.
 * @example {latitude: 55.757195, longitude: 37.648640}
 *
 * TODO: выбрать один из вариантов ICoordinates из hotels/common/common или отсюда
 */
export interface ICoordinates {
    /** Широта */
    latitude: TFloat;
    /** Долгота */
    longitude: TFloat;
}

export enum ECurrencyType {
    RUB = 'RUB',
    RUR = 'RUR',
    USD = 'USD',
    UAH = 'UAH',
    EUR = 'EUR',
    KZT = 'KZT',
    BYN = 'BYN',
    UZS = 'UZS',
    TRY = 'TRY',
    GBP = 'GBP',
}

/** Цена */
export interface IPrice {
    /** Обычно если число, то целочисленная величина; если строка, то чётко отформатированный decimal */
    value: string | number;
    /** Валюта */
    currency: ECurrencyType;
}

/** Тип заказа */
export enum EOrderType {
    HOTEL = 'HOTEL',
    AVIA = 'AVIA',
    TRAIN = 'TRAIN',
    BUS = 'BUS',
}

/** Linguistics */
export interface ILinguistics {
    ablativeCase: string; // '',
    accusativeCase: string; // 'Москву',
    dativeCase: string; // 'Москве',
    directionalCase: string; // '',
    genitiveCase: string; // 'Москвы',
    instrumentalCase: string; // 'Москвой',
    locativeCase: string; // '',
    nominativeCase: string; // 'Москва',
    preposition: string; // 'в',
    prepositionalCase: string; // 'Москве',
}

export enum EGender {
    MALE = 'male',
    FEMALE = 'female',
}

export enum ETernaryChoice {
    YES = 'yes',
    NO = 'no',
    UNKNOWN = 'unknown',
}
