import {ECommonLandingBlockType} from './ECommonLandingBlockType';
import {ILinksListBlock} from './ILinksListBlock';
import {ETransportVertical} from '../vertical';
import {IPrice} from '../common';

interface ITransportRoute {
    transport: ETransportVertical;
    /**
     * Слаг для пункта отправления
     */
    fromSlug: string;
    /**
     * Слаг для пункта прибытия
     */
    toSlug: string;
    /**
     * Текст ссылки на страницу направления
     */
    text: string;
    /**
     * Минимальная цена по направлению (если известна)
     */
    minPrice?: IPrice;
}

export type TTransportRoutesData = ILinksListBlock<ITransportRoute>;

export interface ITransportRoutesBlock {
    type: ECommonLandingBlockType.TRANSPORT_ROUTES;
    data: TTransportRoutesData;
}
