import {TInteger} from '../common';

/** Тип партнерских баллов WL */
export enum EWhiteLabelPointsType {
    S7 = 'WLP_S7',
    TINKOFF = 'WLP_TINKOFF',
    VTB = 'WLP_VTB',
    RAIFFEISEN = 'RAIFFEISEN',
    TELE2 = 'WLP_TELE2',
    OTKRITIE = 'WLP_OTKRITIE',
    BEELINE = 'WLP_BEELINE',
}

/** Партнерские баллы (White Label) */
export interface IWhiteLabelPoints {
    /** Количество баллов */
    amount: TInteger;
    /** Тип баллов */
    pointsType: EWhiteLabelPointsType;
    /** Единица наименования */
    pointsName: string;
}
