# Booking flow

Флоу бронирование отелей на портале Яндекс.Путешествий.

# Работа с промокодами

Работа с промокодами на текущий момент возможна только для залогинов.

На странице ввода данных используется ручка `/api/booking_flow/v1/estimate_discount`, для получения информации о скидке.

### Работа с существующими `promo_campaigns` на примере Яндекс.Такси

При первоначальной отрисовке страницы заказа информация о применимости акции с промокодом на Яндекс.Такси берется из секции `promo_campaigns`, которая приходит в ответ на вызов метода `/api/booking_flow/v1/get_order_info_by_token`.
При первом же запросе на применимость промокода, применимость акции с промокодом Яндекс.Такси получается из ответа `/api/booking_flow/v1/estimate_discount`
В ответе `/api/booking_flow/v1/estimate_discount` приходит секция `promo_campaigns`, аналогичная ответу `/api/booking_flow/v1/get_order_info_by_token`. Если в ней `'taxi2020': { 'eligible': false }` значит к заказу не применяется акция с промокодом Яндекс.Такси. При неприменимости акции на фронте необходимо будет скрыть|зачеркнуть| бейджик с промокодом такси, чтобы пользователь увидел, что акция для него перестала быть действительной.

В метод `create_order` передается список промокодов, и дальше идет поллинг заказа (либо с помощью метода `/api/booking_flow/v1/get_order`, либо более предпочтительно с помощью метода `/api/booking_flow/v1/get_order_status`), пока в ответе не будет получен статус `RESERVED` или `RESERVED_WITH_RESTRICTIONS`

| Статус                       | Результат                                                                                                                                                                                                                                                                                                    |
| ---------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `RESERVED`                   | заказ забронирован, в том числе, если при создании заказа указывались промокоды, они были успешно применены (дополнительная информация доступна в секции `order_price_info`                                                                                                                                  |
| `RESERVED_WITH_RESTRICTIONS` | заказ забронирован, промокоды применить не удалось. В этом случае показываем попап с предупреждением, что не удалось применить промокоды, скидка не применилась и предлагаем пользователю продолжить. При отказе пользователя продолжить дергаем ручку `/api/booking_flow/v1/cancel_order` для отмены заказа |

В тестинге заведены промокоды для тестирования:

| Промокод                  | Описание                                                                                                                                                                  |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `SUCCESS`                 | успешный промокод со скидкой 200 рублей (проставлено 2_000_000_000 в качестве максимального числа использований)                                                          |
| `NOT_APPLICABLE`          | промокод применяемый к заказа свыше 5_000_000 рублей (для получения ошибки, что невозможно применить промокод при заполнении на форме ввода данных                        |
| `EXPIRED`                 | промокод с истекшим сроком действия                                                                                                                                       |
| `SUCCESS_NOT_APPLICABLE`  | промокод, который покажет успешно скидку на форме заполнения данных, при этом не будет применен при бронировании (специальное поведение для окружения отличного от прода) |
| `SUCCESS_ALREADY_APPLIED` | промокод, который покажет успешно скидку на форме заполнения данных, при бронировании не применится со статусом `ALREADY_APPLIED`, уже применен                           |
