import {IHotelGuest} from 'travel/orders/hotels';

import {IAppliedPromoCampaigns} from '../models';

/**
 * Для camelCase, в запросе должен быть передан заголовок: 'X-Ya-UseCamelCase'
 */
export interface IRequest {
    label: string;
    token: string;
    checksum: string;
    customerEmail: string;
    customerPhone: string;
    customerLogin?: string | null;
    customerPassportId?: string;
    customerYandexUid?: string;
    customerUserAgent?: string | string[];
    customerIp?: string | string[];
    /**
     * Гости должны быть том же в порядке, как они пришли в IBookOffer.searchParams.
     *
     * Т.е. если нам пришли в офере: {adults: 2, children: [10, 15]}.
     * То при создании заказа гости тут должны быть в таком порядке:
     * [ взрослый, взрослый, ребенок 10 лет, ребенок 15 лет]
     */
    guests: IHotelGuest[];
    selectedBedGroupIndex: number;
    sessionKey: string;
    promoCodes?: string[];
    useDeferredPayments?: boolean;

    /** Платежный тестовый контекст */
    paymentTestContextToken?: string;
    appliedPromoCampaigns?: IAppliedPromoCampaigns;
}
