import {IPrice, ICoordinates, TInstantDateTime} from 'common/common';
import {THotelSlug} from 'hotels/common/common';
import {
    IRatings,
    IBaseRate,
    IDescriptions,
    IHotelFeeRate,
    IExtraFeeRate,
    IHotelBreadcrumbs,
    IHotelNightlyRate,
    ICancellationPenalty,
    ICheckin,
    ICheckout,
    IFees,
    IPolicies,
    ILocation,
    IHotelAddress,
    IAmenity,
    IRoomDescriptions,
} from 'travel/orders/hotels';

/** TODO: Практически 1:1 повторяет IHotelCharges из travel/orders/hotels.ts - нужно оставить 1 */
export interface IBookOfferHotelChargesResponse {
    nightly: IHotelNightlyRate[];
    totals: {
        base?: IBaseRate;
        taxesAndFees?: IBaseRate[];
        taxesAndFeesSum?: IHotelFeeRate;
        grand?: IBaseRate;
        strikeThrough?: IBaseRate;
        discount?: IBaseRate;
        priceAfterPlusWithdraw?: IPrice;
    };
}

/** TODO: Практически 1:1 повторяет IHotelPriceInfo из travel/orders/hotels.ts - нужно оставить 1 */
export interface IBookOfferRateResponse {
    hotelCharges: IBookOfferHotelChargesResponse;
    extraCharges: IExtraFeeRate[];
}

/** TODO: Практически 1:1 повторяет ICancellationInfo из travel/orders/hotels.ts - нужно оставить 1 */
export interface IBookOfferCancellationInfoResponse {
    refundable: boolean;
    highlighted: boolean;
    penalties: ICancellationPenalty[];
}

export interface IBookHotelImage {
    links: Record<string, {href: string}>;
}

/** TODO: Практически 1:1 повторяет IPartnerHotelInfo из travel/orders/hotels.ts - нужно оставить 1 */
export interface IPartnerHotelInfoResponse {
    name: string;
    category: {
        name: string;
    };
    ratings: IRatings;
    descriptions: IDescriptions;
    checkin: ICheckin;
    checkout: ICheckout;
    fees: IFees;
    phone: string;
    policies: IPolicies;
    location: ILocation;
    address: IHotelAddress;
    amenities: Record<number, IAmenity>;
    images: IBookHotelImage[];
}

/** TODO: Практически 1:1 повторяет IGeoHotelInfo из travel/orders/hotels.ts - нужно оставить 1 */
export interface IBasicHotelInfoResponse {
    address: string;
    coordinates: ICoordinates;
    imageUrlTemplate: string;
    name: string;
    rating: number;
    stars: number;
    permalink: number;
    hotelSlug: THotelSlug;
    breadcrumbs?: IHotelBreadcrumbs;
}

/** TODO: Практически 1:1 повторяет IRoomContentInfo из travel/orders/hotels.ts - нужно оставить 1 */
export interface IBookOfferRoomResponse {
    name: string;
    images: IBookHotelImage[];
    amenities: Record<number, IAmenity>;
    descriptions: IRoomDescriptions;
}

export type TBookLegalInfoResponse = Record<
    string,
    {
        name: string;
        ogrn: string;
        registryNumber: string;
        legalAddress: string;
        actualAddress: string;
        workingHours: string;
    }
>;

export interface IBookInitialDeferredPaymentResponse {
    name: string;
    amount: IPrice;
    percentage: number;
}

export interface IBookDeferredPaymentResponse {
    name: string;
    amount: IPrice;
    percentage: number;
    paymentEndsAt: TInstantDateTime;
    penaltyIfUnpaid: IPrice;
}

export interface IBookDeferredPaymentScheduleResponse {
    initialPayment: IBookInitialDeferredPaymentResponse;
    deferredPayments: IBookDeferredPaymentResponse[];
    zeroFirstPayment: boolean;
}
