import {IExtraVisitAndUserParams} from 'hotels/common/common';
import {IPromoCampaigns} from 'travel/orders/promo-campaigns';
import {IBedGroupInfo, IHotelSearchRequestInfo} from 'travel/orders/hotels';

import {
    IBookOfferRateResponse,
    IBookOfferRoomResponse,
    TBookLegalInfoResponse,
    IBasicHotelInfoResponse,
    IPartnerHotelInfoResponse,
    IBookOfferCancellationInfoResponse,
    IBookDeferredPaymentScheduleResponse,
} from './models';
import {
    ICancellationInfo,
    IHotelOfferMeal,
} from '../../hotel-page-flow/getHotelOffers/models';

export interface IResponse {
    partnerId: string;
    label: string;
    checksum: string;
    sessionKey: string;
    travelToken: string;
    bedGroups: IBedGroupInfo[] | null;
    rateInfo: IBookOfferRateResponse;
    refundInfo?: ICancellationInfo;
    cancellationInfo?: IBookOfferCancellationInfoResponse;
    cancellationInfoUnfiltered?: IBookOfferCancellationInfoResponse;
    partnerHotelInfo: IPartnerHotelInfoResponse;
    basicHotelInfo: IBasicHotelInfoResponse;
    partnerRoomInfo: IBookOfferRoomResponse;
    pansionInfo: IHotelOfferMeal;
    legalInfo: TBookLegalInfoResponse;
    requestInfo: IHotelSearchRequestInfo;
    directPartner: boolean;
    promoCampaigns?: IPromoCampaigns;
    deferredPaymentSchedule?: IBookDeferredPaymentScheduleResponse | null;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
    allGuestsRequired: boolean;
}
