import {TUuid} from '../../../common/common';
import {EHotelOrderStatus} from '../../../common/hotel_orders';
import {IResponse as IBookOfferResponse} from '../get-offer-by-token/response';
import {
    IHotelCancellationDetails,
    IHotelOrderConfirmationInfo,
    IHotelOrderRefundInfo,
} from '../../../travel/orders/hotels';
import {IAppliedPromoCampaigns} from '../models';
import {IOrderPriceInfo} from '../../../travel/orders/generic-booking-flow/common';
import {
    EDisplayOrderState,
    IHotelOrderGuestInfo,
    IHotelOrderPaymentInfo,
} from '../../../travel/orders/getOrderHappyPage/models/models';

export interface IResponse {
    id: TUuid;
    yandexOrderId: string;
    orderInfo: IBookOfferResponse;
    guestInfo: IHotelOrderGuestInfo;
    status: EHotelOrderStatus;
    displayState: EDisplayOrderState;
    orderCancellationDetails?: IHotelCancellationDetails | null;
    payment?: IHotelOrderPaymentInfo;
    confirmationInfo: IHotelOrderConfirmationInfo;
    refundInfo?: IHotelOrderRefundInfo;
    orderPriceInfo?: IOrderPriceInfo;
    appliedPromoCampaigns?: IAppliedPromoCampaigns;

    /**
     * id поездки, к которой привязан заказ. Если поездки еще нет, то отсутствует
     */
    tripId?: TUuid | null;

    /**
     * Доступна ли генерация командировочного документа.
     */
    canGenerateBusinessTripDoc?: boolean;
}
