import {IWhiteLabelInfo} from 'common/white-label/IWhiteLabelInfo';

/* eslint camelcase: off */
import {ECurrencyType, TInstantDateTime, TInteger} from '../../common/common';

export interface IPrice {
    amount: number;
    currency: ECurrencyType;
}

export interface IDeferredPayment {
    amount: IPrice;
    percentage?: number;
    paymentEndsAt: TInstantDateTime;
    penaltyIfUnpaid: IPrice;
}

export interface IInitialDeferredPayment {
    amount: IPrice;
    percentage?: number;
}

export interface IDeferredPaymentSchedule {
    initialPayment: IInitialDeferredPayment;
    deferredPayments: IDeferredPayment[];
    zeroFirstPayment: boolean;
}

/**
 * Отражает результат применения промо-акции к заказу.
 * Может содержать результат выбора или иные данные, завязанные не на общий оффер, а на конкретный заказ.
 */
export interface IAppliedPromoCampaigns {
    yandexPlus?: IYandexPlusApplicationInfo;
    whiteLabel?: IWhiteLabelInfo;
}

/* описывает выбранный режим использования Плюса: начисление или списание и баллы */
export interface IYandexPlusApplicationInfo {
    mode: EYandexPlusApplicationMode;
    /* баллы, которые фактически начисляются или списываются */
    points: TInteger;
}

export enum EYandexPlusApplicationMode {
    /* начисление */
    TOPUP = 'TOPUP',
    /* списание */
    WITHDRAW = 'WITHDRAW',
}
