## Идентификаторы отеля

Есть два способа идентификации отеля:

-   По пермалинку

Пермалинк - это числовой идентификатор отеля. Пример: `1054982517`.
У разных отелей пермалинки гарантированно разные.
У одного отеля может быть несколько пермалинков, один из которых является главным (a.k.a. "голова кластера").
Главный пермалинк со временем может изменяться.
В данной спецификации главный пермалинк нигде не фигурирует.

-   По slug-у

Slug - это текстовый идентификатор отеля. Используется для того, чтобы сформировать ЧеловекоПонятныйУрл (ЧПУ)
страницы отеля.
Slug в URL-е может состоять из нескольких частей, разделенных прямым слэшом "/".
Пример: `moscow/novotel-kievskaya`

**Важно!** У отеля может быть несколько slug-ов. При этом только один slug является **главным**.

### Требования к бэкенду

-   Во всех запросах, касающихся одного отеля (getHotelInfo, getHotelImages, getHotelOffers, getHotelReviews, getSimilarHotels, setHotelReviewReaction)
    в качестве идентификатора отеля принимается или пермалинк, или slug. Если переданы оба, то бэкенд отвечает 4хх ошибкой.
-   В ответах на запросы getHotelInfo, getSimilarHotels, searchHotels про каждый отель возвращается пермалинк и главный slug.

### Требования к фронтенду

-   Если пользователь пришёл на страницу отеля с урлом в старом формате (`https://travel.yandex.ru/hotels/hotel/?hotelPermalink=xxx`),
    то в запрос getHotelInfo к бэкенду передаётся пермалинк.
-   Если пользователь пришёл на страницу отеля с урлом в новом формате (`travel.yandex.ru/hotels/moscow/holiday-inn-express`),
    то фронт из урла выделяет slug отеля (в данном случае `moscow/holiday-inn-express`) и передаёт его в запрос getHotelInfo к бэкенду.
-   В ответе на запрос getHotelInfo приходит **главный** slug отеля. Фронт должен проверить, если этот slug не совпадает с тем,
    который был выделен из урла (или же урл вообще был в старом формате), то необходимо сгенерировать редирект на URL в новом формате с этим главным slug-ом.
-   Если из URL-а или из getSimilarHotels/searchHotels/suggest фронт получил и permalink и hotelSlug, то фронт в дальнейшие запросы в бэк передаёт только hotelSlug. Если же hotelSlug-а нет - то фронт передает permalink. Таким образом, hotelSlug - более приоритетен, чем permalink.
