import {IPrice} from '../../../common/common';
import {
    ICoordinates,
    IGeoRegion,
    IHotelWithOffers,
    IOfferSearchProgress,
} from '../../common/common';
import {IHotelWithMinPrice} from '../../seo-pages/city/models';

interface ICrossSaleHotels {
    /**
     * Есть ли данные для указанного в запросе региона.
     * Если true, то поля ниже заполнены, иначе - пусты.
     *
     * @depricated при наличии этого поля остальные поля приходят как null, что не соотвествует спеке. Нужно отказаться от этого поля и либо не возвращать этот блок в массиве при запросе SEO страниц, либо возвращать 404 при отдельном запросе этого блока
     */
    hasData: boolean;

    // Информация об изначальном регионе поиска, соответствует geoId из запроса
    region: IGeoRegion;

    // Минимальная цена за одну ночь на отели в searchRegion
    minPriceInRegion: IPrice;

    // Ограничивающий прямоугольник для карты.
    bboxAsString: string; // 37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat
    // Он же, но в виде списка.
    bboxAsStruct: ICoordinates[];

    // Сколько всего отелей в регионе, без учёта totalHotelLimit
    totalHotelCount: number;

    // Ссылка на картинку региона
    regionImageUrl: string;
}

export interface ICrossSaleHotelsWithMinPrices extends ICrossSaleHotels {
    // Список отелей в регионе этом регионе, не больше, чем totalHotelLimit в запросе
    hotels: IHotelWithMinPrice[];
}

export interface ICrossSaleHotelsWithOffers extends ICrossSaleHotels {
    offerSearchProgress: IOfferSearchProgress;
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

    // Список отелей в регионе этом регионе, не больше, чем totalHotelLimit в запросе
    hotels: IHotelWithOffers[];
}
