import {
    ICoordinates,
    IGeoRegion,
    IHotelWithOffers,
} from '../../../common/common';
import {IPrice} from '../../../../common/common';

export interface IHotelsCrossSale {
    // Информация об изначальном регионе поиска, соответствует geoId из запроса
    region: IGeoRegion;

    // Минимальная цена за одну ночь на отели в searchRegion
    minPriceInRegion: IPrice;

    // Ограничивающий прямоугольник для карты.
    bboxAsString: string; // 37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat
    // Он же, но в виде списка.
    bboxAsStruct: ICoordinates[];

    // Список отелей в регионе этом регионе, не больше, чем totalHotelLimit в запросе
    hotels: IHotelWithOffers[];

    // Сколько всего отелей в регионе, без учёта totalHotelLimit
    totalHotelCount: number;

    // Ссылка на картинку региона
    regionImageUrl: string;
}
