import {IHotelGuest} from 'travel/orders/hotels';

import {IPrice, TDate, TInstantDateTime} from '../../../common/common';
import {IPriceBreakdown} from '../get_orders/response';
import {IHotel} from '../models';

export interface IResponse {
    result: IBankOrderInfoDetail[];
    /** сумма посчитанная по result. Должно совпадать  с суммой п/п, но могут быть случаи, когда
     * не совпадает */
    sum: IPrice;
}

/**
 *  конкретная строчка в расшифровке п/п, может быть привязана к одному заказу
 *
 * nullable поля в случае если сматчить с заказом не удалось. Такое может быть в короткий период времени в момент когда значения загрузились, но
 * вьюха не посчиталась, или если что-то пошло не так при подсчете.
 */
interface IBankOrderInfoDetail {
    /**
     * Тип транзакции. (BillingTransactionType)
     * PAYMENT - платит пользователь
     * REFUND - возвращаем деньги пользователю.
     *
     * Если REFUND - какие-то суммы надо отображать с минусом, с бэка передаются положительные.
     */
    transactionType: 'BTTT_PAYMENT' | 'BTTT_REFUND';
    hotel?: IHotel;

    orderId?: string;
    orderPrettyId?: string;

    firstGuest?: IHotelGuest;

    orderCreatedAt?: TInstantDateTime;
    checkInDate?: TDate;
    checkOutDate?: TDate;

    /**
     * Содержит только hotelPrice, fiscalPrice, partner
     */
    priceBreakdown: IPriceBreakdown;
}
