import {IPrice} from '../../../common/common';
import {ITableData} from '../models';

export interface IResponse {
    hotelId: string;
    tableData: ITableData<IBankOrderInfo>;
    /** Сумма того что пользователь видит на странице */
    sum: IPrice;
}

/** Платежное поручение */
interface IBankOrderInfo {
    /** id из биллинге, номер п/п теоретически не уникальный */
    paymentBatchId: string;
    /** номер п/п */
    bankOrderId: String;
    /** Дата платежа. */
    eventTime: String;
    /** номер п/п */
    status: String;
    /** TBD */
    localizedStatus?: String;
    /** сумма. для API "строка", но, естественно, это число */
    sum: IPrice;
    /** многословное описание п/п, получаем от биллинга */
    description: String;
}
