import {EHotelPartnerId} from 'travel/orders/hotels';

import {
    EExtranetOrderStatus,
    IDateFilter,
    IPageable,
    TSorting,
} from '../models';

export interface IRequest {
    originalId: string;
    partnerId: EHotelPartnerId;

    checkInDate?: IDateFilter;
    checkOutDate?: IDateFilter;
    orderedAt?: IDateFilter;
    cancelledAt?: IDateFilter;
    orderStatus?: EExtranetOrderStatus[];
    page: IPageable;
    sortFields?: TSorting<
        | 'fiscalPrice'
        | 'feeAmount'
        | 'partnerAmount'
        | 'checkOutDate'
        | 'checkInDate'
        | 'cancelledAt'
        | 'createdAt'
    >;
}
