import {IHotelGuest} from 'travel/orders/hotels';

import {IPrice, TDate, TInstantDateTime, TUuid} from '../../../common/common';
import {EExtranetOrderStatus, ITableData} from '../models';

export interface IResponse extends ITableData<IExtranetOrderInfo> {
    /** сумма комиссии того что на странице */
    feeSum: IPrice;
    /** сумма оплат отелю того что на странице */
    partnerSum: IPrice;
    /** сумма того что показали пользователю (без скидки) */
    fiscalSum: IPrice;
}

interface IExtranetOrderInfo {
    /** guid */
    id: TUuid;
    /** YA-1111-1111-1111 */
    prettyId: string;
    /** номер заказа у Travelline/BNovo */
    partnerOrderId: string;
    /** Имя 1-го гостя */
    firstGuest: IHotelGuest;
    status: EExtranetOrderStatus;
    /** дата бронирования */
    createdAt: TInstantDateTime;
    /** дата обновления заказа */
    updatedAt: TInstantDateTime;
    /** дата отмены */
    cancelledAt?: TInstantDateTime;

    /** проживание с */
    checkInDate: TDate;
    /** проживание до */
    checkOutDate: TDate;

    /** денежные поля */
    priceBreakdown?: IPriceBreakdown;
    /** информация о п/п, может быть пустым листом */
    bankOrderInfo: IBankOrderInfo[];
}

interface IBankOrderInfo {
    bankOrderId: string;
}

export interface IPriceBreakdown {
    /** полная цена для пользователя*/
    fiscalPrice?: IPrice;
    /** цена от отеля (чаще совпадает с fiscal price), но бывают приколы с копейками */
    hotelPrice?: IPrice;
    /** полная скидка (и по промокодам, и по специальным программам). Сумма от пользователя = fiscalPrice - discount */
    discount?: IPrice;

    /** Сумма, которую реально заплатил пользователь (с учетом отмены, частичной отмены и т.п.) */
    paidAmount?: IPrice;

    // поля ниже nullable потому что они считаются с некоторой задержкой. Мы не пытаемся пересчитывать их вне оркестратора.
    /** комиссия яндекса */
    fee?: IPrice;
    /** сумма брони к перечислению `(hotelPrice || fiscalPrice)-fee` */
    partner?: IPrice;

    /** дата оплаты партнеру */
    payoutAt?: TInstantDateTime;
}
