import {EHotelPartnerId} from 'travel/orders/hotels';

export interface IBankOrderInfo {
    /** номер п/п */
    id: string;
    /**
     * Описание в стиле
     *  П/п №123 от 01.01.1000 Р/сч 1234 в банке ..., партнер
     */
    description: string;
}

export interface ITableData<T> {
    totalRecords: number;
    hotelInfo: IHotel;
    result: T[];
}

export enum EExtranetOrderStatus {
    EOS_UNKNOWN = 'EOS_UNKNOWN',
    EOS_PREPAID = 'EOS_PREPAID',
    EOS_AWAITS_PAYMENT = 'EOS_AWAITS_PAYMENT',
    EOS_REFUNDED = 'EOS_REFUNDED',
    EOS_SERVED = 'EOS_SERVED',
}

export interface IPageable {
    num: number;
    limit: number;
}

/** одна из границ может отсутствовать */
export interface IDateFilter {
    from?: string;
    till?: string;
}

export type TSorting<COLUMNS> = {
    field: COLUMNS;
    sortDirection: 'SD_ASC' | 'SD_DESC';
}[];

export type THoteldId = {
    originalId: string;
    partnerId: EHotelPartnerId;
};

export interface IHotel {
    name?: string;
    /** пара partnerId + hotelCode - идентификатор отеля */
    partnerId: EHotelPartnerId;
    hotelCode: string;
    /** теоретически может быть случай когда пермалинк мы ЕЩЕ не знаем. Тогда никакой ссылки на портал мы показать не можем. */
    permalink?: number;
    slug?: string;
}
