import {IFavoriteCategory} from './models';
import {
    IRequiredOfferSearchParams,
    IOfferSearchProgress,
    IExtraVisitAndUserParams,
    IHotelWithOffers,
} from '../../common/common';

export interface IResponse {
    /** Состояние параметров поиска предложений.
    // На фронте -- необходимо обновить состояние на указанные в ответе параметры (даже если параметры в запросе уже были).
    // На бекенде -- если параметры валидные (т.е. присутствуют, и это не даты в прошлом), то вернуть их же; если нет, то подсказать. */
    offerSearchParams: IRequiredOfferSearchParams;

    offerSearchProgress: IOfferSearchProgress;
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

    /** Контекст поллинга, нужно передать в следующие запросы в getHotelOffers, если они будут */
    context: string;

    /** Id выбранной категории (может отличаться от переданного в запросе) */
    selectedCategoryId: string;

    /** Все доступные категории. Обязательно содержит категорию с id == category */
    categories: IFavoriteCategory[];

    hotels: IHotelWithOffers[];
    totalHotelCount: number;

    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
