import {IShortHotelOffersInfo} from './models';
import {
    IRequiredOfferSearchParams,
    IOfferSearchProgress,
    IExtraVisitAndUserParams,
    TPermalink,
} from '../../common/common';
import {IFavoriteCategory} from '../getFavoriteHotels/models';

export interface IResponse {
    /** Состояние параметров поиска предложений.
    // На фронте -- необходимо обновить состояние на указанные в ответе параметры (даже если параметры в запросе уже были).
    // На бекенде -- если параметры валидные (т.е. присутствуют, и это не даты в прошлом), то вернуть их же; если нет, то подсказать. */
    offerSearchParams: IRequiredOfferSearchParams;

    offerSearchProgress: IOfferSearchProgress;
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

    /** Нужно передать в последющие запросы в getHotelOffers */
    context: string;

    /** Категория этого списка (нужна для заголовка на странице) */
    category: IFavoriteCategory;

    /** Информация обо всех запрошенных пермалинках: и завершённых, и нет */
    offers: Map<TPermalink, IShortHotelOffersInfo>;

    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
