import {
    TOptionalOfferSearchParams,
    IDebugOfferSearchParams,
    IAttribution,
} from '../../common/common';

export interface IRequest
    extends TOptionalOfferSearchParams,
        IDebugOfferSearchParams,
        IAttribution {
    /** Домен для транслокальности. */
    domain?: string;

    /**
     * Токен, полученный, когда пользователь поделился избранным
     */
    token: string;

    /** Сколько фотографий вернуть. По умолчанию - все. */
    imageLimit?: number;
    /** Размеры фотографий, которые надо вернуть. По умолчанию - все. */
    imageSizes?: String[];

    /** Для паджинации */
    /** Сколько отелей пропустить */
    offset: number;
    /** Сколько отелей вернуть (максимум) */
    limit: number;
}
