## TODO

-   [ ] Разобраться с моделью данных для отмен на метасерче и бронированиях (-> tivelkov@)
-   [ ] Расстояние до метро.

## Термины

-   Партнер - лицо, обеспечивающее техническую интеграцию для получения данных об отеле.
-   Оператор - набор информации о поставщике предложения, используемый только для нужд отрисовки предложения.

## Методы

-   `getHotelInfo`:: `GET /api/hotels_portal/v1/get_hotel_info`
-   `getHotelOffers`:: `GET /api/hotels_portal/v1/get_hotel_offers`
-   `getHotelImages`:: `GET /api/hotels_portal/v1/get_hotel_images`
-   `getSimilarHotels`:: `GET /api/hotels_portal/v1/get_similar_hotels`
-   `getCalendarPrices` :: `GET /api/hotels_portal/v1/get_calendar_prices`

---

## Требования к бекенду

### Параметры поиска предложений

-   Подбирать даты и размещение по умолчанию для страницы отеля, если offer-search-params не указаны в первичном запросе.

### Макет

-   Определять макет страницы (layout): meta или book -- в зависимости от отеля.
    -   На текущем этапе предлагается использовать факт наличия провязки с BoY-партнером для выбора макета страницы. (sandello@, 14.10.2019)

### Атрибуция

-   В запросах `getHotelInfo`, `getHotelOffers`, `getSimilarHotels` необходимо пробрасывать информацию от фронта об атрибуции в оффер-кеш для генерации обогащенных лейблов.
-   Кроме utm- и ytp-меток необходимо пробрасывать контекст отрисовки оффера в лейбл.
    -   Отличаем методы `getHotelInfo` + `getHotelOffers` от `getSimilarHotels`.
    -   Отличаем главный таб от вторичного (главный == вызов `getHotelInfo` или вызов `getHotelOffers` с `full=0`; вторичный -- `getHotelOffers` с `full=1`).
    -   Для дефолтного оффера необходимо в лейбле сохранить информацию, что это дефолтный лейбл.
-   В лейблы сохраняем фронтовый `requestId` (пробрасывается с фронта через заголовок) и `parentRequestId`.

### Хлебные крошки

-   По координатам отеля строим цепочку его регионов; по ним строим хлебные крошки.
    -   Сверху ограничиваем страной, снизу не ограничиваем. (sandello@, 20.09.2019)

### Предложения

-   Если в прогрессе поиска `isFinished=0`, то стараемся лишних данных не отправлять.
-   Передаем информацию об операторах один раз, в `getHotelInfo`.
    -   Передаем информацию о тех операторах, которые соответствуют партнерам, для которых есть провязки у отеля.
    -   Для BoY-страницы передавать только информацию о BoY-операторах.

---

## Требования к фронтенду

### Параметры поиска предложений

-   Страница отеля может быть отрисована без указания offer-search-params в query-параметрах.
    -   В этом случае значения для полей выбора дат задаются из ответа бекенда.

### Макет

-   Страница может быть отрисована в двух вариантах: мета и BoY.
    -   Для BoY-страницы подписи на кнопках меняются с "Выбрать" на "Забронировать".
    -   Для BoY-страницы добавляются бейджи "Покупка на Яндексе".

### Атрибуция

-   При запросах `getHotelInfo`, `getHotelOffers`, `getSimilarHotels` важно передавать атрибуцию о пользователе.
    -   Передаем utm-метки, ytp-метки.
    -   Метки должны сохраняться при перемещении пользователя по страницам портала в рамках одной сессии.
-   При всех запросах к бекенду должен передаваться `requestId` (через заголовок).
-   При всех запросах к бекенду, _кроме первого запроса `getHotelInfo`_, необходимо передавать `parentRequestId`.
    -   Значение для `parentRequestId` необходимо взять из ответа на `getHotelInfo`.

### Хлебные крошки

-   Ссылки по хлебным крошкам должны вести на страницу поиска в регионе с сохранением указанных пользователем дат и размещения (offer-search-params).

### Предложения

-   При первичной отрисовке страницы (`getHotelInfo`) получаем информацию обо всех блоках: и о предложениях, и о похожих отелях.
    -   Если данные есть (в прогрессе `isFinished==true`), то рисуем блоки сразу и больше ничего не делаем.
    -   Если данных нет, то рисуем скелетоны и поллим.
-   На главной вкладке при отрисовке секции проставляем `full=0` в запросе `getHotelOffers`.

### Фронтовый урл страницы одного отеля

Для того, чтобы формировать ссылки на страницу отеля нужно зафиксировать формат урла.
Сам урл должен быть таким: <hostname>/hotels/hotel?параметры.
Параметры:

-   hotelPermalink - пермалинк отеля
-   startDate - дата заезда
-   endDate - дата выезда
-   childrenAges - список возрастов детей (через запятую)
-   adults - кол-во взрослых
-   token - токен (пробрасывается в бэкенд as is)
-   label - label (пробрасывается в бэкенд as is)
