import {TDate} from '../../../common/common';
import {IHotelIdentifier} from '../../common/common';

export interface IRequest extends IHotelIdentifier {
    // Начальная дата поиска цен
    startDate: TDate;
    // Конечная дата поиска цен
    endDate: TDate;

    // Для получения календаря цен дату въезда и выезда заполнять не нужно
    // Если заполнено, то возвращаются свободные даты на N ночей в период [startDate, endDate)
    // Дата заселения в гостиницу в формате YYYY-MM-DD.
    checkinDate?: TDate;
    // Дата выезда из гостиницы
    checkoutDate?: TDate;

    // Количество взрослых.
    adults: number;
    // Массив возрастов детей.
    childrenAges: number[];
    // при первом запросе передавать не нужно
    // если get_calendar_prices вернул isFinished === false,
    // то при повторном запросе для получения оставшихся цен
    // нужно передать context полученный из первого запроса
    context?: string;
}
