import {
    TOptionalOfferSearchParams,
    IDebugOfferSearchParams,
    IAttribution,
    IHotelIdentifier,
    ETextReviewRankingType,
} from '../../common/common';
import {ELayoutType} from './models';

// NB: Параметры поиска предложений -- опциональные!
// NB: Передавать атрибуцию.
export interface IRequest
    extends TOptionalOfferSearchParams,
        IDebugOfferSearchParams,
        IAttribution,
        IHotelIdentifier {
    /** Домен для транслокальности. */
    domain: string;

    /** Смещение выдачи (сколько элементов с начала списка пропустить).
     * textReviewOffset должен делиться на textReviewLimit без остатка. */
    textReviewOffset?: number;
    /** Лимит на число текстовых отзывов. */
    textReviewLimit?: number;
    /** Способ сортировки отзывов. */
    textReviewRanking?: ETextReviewRankingType;
    /** Лимит на число похожих отелей. */
    similarHotelLimit?: number;
    /** Лимит на число изображений. */
    imageLimit?: number;
    /** Размеры фотографий, которые надо вернуть. По умолчанию - все. */
    imageSizes?: String[];
    /** Лимит на число ключевых слов. */
    keyPhraseLimit?: number;
    /** Фильтр отзывов по ключевому слову. */
    keyPhraseFilter?: string;

    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;

    /** !DEPRECATED!
     * Частичный или полный ответ необходим.
     * full == false: используется на странице отеля на главном табе.
     * full == true: используется на табе предложений. */
    full: boolean;

    /** Маркер запроса, влияющий на отображение страницы, пробрасывается из параметров url-а без изменений */
    seed?: string;

    /** Метка, пробрасывается из параметров url-а без изменений */
    label?: string;
    /** Токен, пробрасывается из параметров url-а без изменений */
    token?: string;
    /**
     * Маркер, говорящий использовать значения по умолчанию для поиска
     */
    useDefaultSearchParams?: boolean;

    // --- Отладочные параметры. ---

    /** !DEPRECATED! Форсирует отрисовку страницы в том или ином макете. */
    debugForceLayout?: ELayoutType;

    /** Маркер для проведения экспериментов, которыми руководит фронт. Изначально задуман для экспериментов с boy+meta. */
    experiments?: string;
}
