import {IReviewsInfo} from 'hotels/reviews/getHotelReviews/models';

import {
    IRequiredOfferSearchParams,
    IBreadcrumbs,
    IExtraVisitAndUserParams,
} from '../../common/common';
import {
    IHotel,
    IHotelDescription,
    IRatingsInfo,
    ELayoutType,
    IHotelSeoInfo,
} from './models';
import {IHotelOffersInfo} from '../getHotelOffers/models';
import {ISimilarHotelsInfo} from '../getSimilarHotels/models';

export interface IResponse {
    /** Состояние параметров поиска предложений.
    // На фронте -- необходимо обновить состояние на указанные в ответе параметры (даже если параметры в запросе уже были).
    // На бекенде -- если параметры валидные (т.е. присутствуют, и это не даты в прошлом), то вернуть их же; если нет, то подсказать. */
    searchParams: IRequiredOfferSearchParams;

    /** Идентификатор текущего запроса.
    // На фронте -- использовать для всех последующих вызовов.
    // На бекенде -- или вернуть request-id текущего запроса, или сгенерировать UUID. */
    parentRequestId: string;

    /** !DEPRECATED! **/
    layout: ELayoutType;

    hotel: IHotel;
    hotelDescription: IHotelDescription;
    breadcrumbs: IBreadcrumbs;

    offersInfo: IHotelOffersInfo;
    similarHotelsInfo: ISimilarHotelsInfo;
    reviewsInfo: IReviewsInfo;
    ratingsInfo: IRatingsInfo;
    seoInfo: IHotelSeoInfo;

    /*
     * Хлебные крошки для SEO. Отображаются на странице отеля
     * Первый пункт "Отели" отображается всегда (не передаётся в seoBreadcrumbs)
     * Пример отображения: Отели -> Свердловская область -> Екатеринбург -> Hyatt Regency Ekaterinburg 5*
     * !!! здесь заполняется только items, geoRegions не заполняется
     * */
    seoBreadcrumbs: IBreadcrumbs;

    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
