import {
    IRequiredOfferSearchParams,
    IDebugOfferSearchParams,
    IAttribution,
    IHotelIdentifier,
} from '../../common/common';

// NB: Параметры поиска предложений -- обязательные!
// NB: Передавать атрибуцию.
export interface IRequest
    extends IRequiredOfferSearchParams,
        IDebugOfferSearchParams,
        IAttribution,
        IHotelIdentifier {
    /** Домен для транслокальности. */
    domain: string;

    parentRequestId: string;

    /** !DEPRECATED!
     * Частичный или полный ответ необходим.
     * full == false: используется на странице отеля на главном табе.
     * full == true: используется на табе предложений. */
    full: boolean;

    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;

    /** Маркер запроса, влияющий на отображение страницы, пробрасывается из параметров url-а без изменений */
    seed?: string;

    /** Метка, пробрасывается из параметров url-а без изменений */
    label?: string;
    /** Токен, пробрасывается из параметров url-а без изменений */
    token?: string;

    /** Маркер для проведения экспериментов, которыми руководит фронт. Изначально задуман для экспериментов с boy+meta. */
    experiments?: string;
}
