import {
    IRequiredOfferSearchParams,
    IDebugOfferSearchParams,
    IAttribution,
    IHotelIdentifier,
} from '../../common/common';

// NB: Параметры поиска предложений -- обязательные!
// NB: Передавать атрибуцию.
export interface IRequest
    extends IRequiredOfferSearchParams,
        IDebugOfferSearchParams,
        IAttribution,
        IHotelIdentifier {
    parentRequestId: string;

    /** Лимит на размер выдачи. */
    similarHotelLimit?: number;

    /** Маркер для проведения экспериментов, которыми руководит фронт. Изначально задуман для экспериментов с boy+meta. */
    experiments?: string;

    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;
}
