import {TInstantDateTime} from '../../../common/common';
import {IHotelImage} from '../../hotel-page-flow/getHotelImages/models';

export enum EUserReaction {
    NONE = 'NONE',
    LIKE = 'LIKE',
    DISLIKE = 'DISLIKE',
}

export interface IKeyPhraseMatchFragment {
    /** Начальная позиция фрагмента */
    position: number;
    /** Размер фрагмента */
    size: number;
}

export interface IKeyPhraseMatch {
    /** Список фрагментов, совпадающих с ключевым словов */
    fragments: IKeyPhraseMatchFragment[];
}

export interface ITextReview {
    /** Идентификатор отзыва. */
    id: string;
    /** Полный текст отзыва.
     * @example Пример: "Хороший отель, все понравилось." */
    text: string;
    /** Время последнего обновления. */
    updatedAt: TInstantDateTime;

    /** Автор отзыва. */
    author?: ITextReviewAuthor;
    /** Рейтинг отзыва. Целочисленный от 1 до 5.
     * Он же -- "Сколько звездочек в отзыве? */
    rating: number;
    /** Общее число лайков. */
    totalLikeCount: number;
    /** Общее число дизлайков. */
    totalDislikeCount: number;
    /** Реакция текущего пользователя.
     * Если 'NONE', то пользователь ничего не делал.
     * Если 'LIKE', то пользователь уже поставил лайк; лайк-кнопку можно выключать и рисовать зеленым.
     * Если 'DISLIKE', то пользователь уже поставил дизлайк; дизлайк-кнопку можно выключать и рисовать красным. */
    userReaction: EUserReaction;
    /** Количество комментариев для отзыва */
    commentCount: number;
    /** Фотографии, прикрепленные к отзыву */
    images: IHotelImage[];

    keyPhraseMatch?: IKeyPhraseMatch;
    /** Краткое превью текста отзыва */
    snippet: string;
}

export interface ITextReviewAuthor {
    /** Имя или никнейм автора.
     * @example "Ксения С." */
    name: string;
    /** Уровень.
     * @example "Знаток города 15 уровня" */
    level: string;
    /** Ссылка на аватарку, если есть. */
    avatarUrl?: string;
    /** Ссылка на профиль пользователя. */
    profileUrl: string;
}

export interface IBusinessComment {
    /** Идентификатор отзыва. */
    id: string;
    /** Полный текст ответа.
     * @example "У нас сам хороший отель в мире, вы обманываете нас..." */
    text: string;
    /** Время последнего обновления.*/
    updatedAt: TInstantDateTime;
}

export interface IKeyPhrase {
    /** Отображаемое название ключевой фразы.
     * @example "Приятный интерьер", "Хорошая кухня", "Долго готовят". */
    name: string;
    /** Сколько отзывов содержат данную ключевую фразу. */
    reviewCount: number;
}

export interface IReviewsInfo {
    /** Общее число текстовых отзывов. */
    totalTextReviewCount: number;
    /** Текстовые отзывы на данной странице. */
    textReviews: ITextReview[];
    /** Текстовыей отзыв текущего пользователя. */
    userTextReview: ITextReview;

    /** Общее число ключевых слов/интентов. */
    totalKeyPhraseCount: number;
    /** Ключевые слова / интенты. */
    keyPhrases: IKeyPhrase[];

    /** Можно ли дозагрузить еще отзывы.
     * Если при hasMore: false запрашивать следующую пачку отзывов, то апи вернет 400
     */
    hasMore: boolean;
}
