import {IHotelIdentifier, ETextReviewRankingType} from '../../common/common';

export interface IRequest extends IHotelIdentifier {
    parentRequestId: string;

    /** Лимит на размер выдачи. */
    textReviewLimit?: number;
    /** Смещение выдачи (сколько элементов с начала списка пропустить).
     * textReviewOffset должен делиться на textReviewLimit без остатка. */
    textReviewOffset?: number;
    /** Лимит на размер выдачи. */
    keyPhraseLimit?: number;
    /** Фильтр отзывов по ключевому слову. */
    keyPhraseFilter?: string;
    /** Способ сортировки отзывов. */
    textReviewRanking?: ETextReviewRankingType;

    /** Маркер для проведения экспериментов, которыми руководит фронт. Изначально задуман для экспериментов с boy+meta. */
    experiments?: string;
    /** Включить использование тестового инстанса UGC в АПИ. Работает только в тестинге */
    enabledTestUgc?: boolean;
}
