import {
    IRequiredOfferSearchParams,
    IDebugOfferSearchParams,
} from '../../common/common';
import {IFilterParams, ISortParams} from '../searchHotels/models';

// NB: Параметры поиска предложений -- опциональные!
// NB: Передавать атрибуцию.
export interface IRequest
    extends IRequiredOfferSearchParams,
        IDebugOfferSearchParams,
        IFilterParams,
        ISortParams {
    // Контекст из последнего завершённого поллинга.
    // В рамках одного контекста набор фильтров меняться не будет (даже между ручками searcHotels/countHotels):
    // можно отрисовать фильтры по завершении поллинга и дальше менять только count-ы при кликах пользователя.
    context: string;

    // Окно карты, передаётся всегда
    bbox: string; // bbox=37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat
}
