import {
    IRequiredOfferSearchParams,
    IDebugOfferSearchParams,
    IAttribution,
    TGeoId,
    EGeoLocationStatus,
    THotelSlug,
} from '../../common/common';
import {IFilterParams, ISortParams, EStartSearchReasonType} from './models';

// NB: Параметры поиска предложений -- опциональные!
// NB: Передавать атрибуцию.
export interface IRequest
    extends IRequiredOfferSearchParams,
        IDebugOfferSearchParams,
        IAttribution,
        IFilterParams,
        ISortParams {
    domain: string; // domain=ru

    // Геопоисковый контекст.
    context: string;
    // Навигационный контекст для смены отображаемой страницы _в списке_.
    navigationToken: string;

    // Регион поиска, заданный пользователем (при первичном запросе).
    geoId: TGeoId;
    // Окно карты (при последующих запросах).
    bbox?: string; // bbox=37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat

    // Сколько отелей отображать в списке.
    // Нужно для корректного формирования навигационных токенов.
    pageHotelCount: number;
    // Сколько отелей желательно получить с ценами.
    pricedHotelLimit: number;
    // Сколько отелей нужно всего.
    totalHotelLimit: number;

    /** Сколько фотографий вернуть. По умолчанию - все. */
    imageLimit?: number;
    /** Размеры фотографий, которые надо вернуть. По умолчанию - все. */
    imageSizes?: String[];

    // Номер сессии поллинга фронта (для отладки и аналитики).
    pollEpoch: number;
    // Номер итерации поллинга фронта (для отладки и аналитики).
    pollIteration: number;

    // Причина, по которой фронт запустил процесса поллинга
    startSearchReason: EStartSearchReasonType;

    geoLocationStatus: EGeoLocationStatus;

    /**
     * Обязательно передаётся, если geoLocationStatus==available
     *
     * Обязательно передаётся при явном выборе пользователем сортировки с requiresGeoLocation==true. В этом случае сценарий такой:
     *     - у пользователя запрашивается доступ к геолокации
     *     - userCoordinates (вместе с новым selectedSortId) отправляется на бек
     *     - в ответ приходит sortInfo с обновлённым sortOrigin
     *     - в последующих запросах userCoordinates уже не передаётся, сортировка происходит относительно фиксированного sortOrigin
     */
    userCoordinates?: string; // userCoordinates=37.0408809,55.311850; // lon,lat

    // Показать первым в списке отель с этим слагом.
    topHotelSlug?: THotelSlug;
}
