import {
    IRequiredOfferSearchParams,
    IGeoRegion,
    ICoordinates,
    IOfferSearchProgress,
    IExtraVisitAndUserParams,
    THotelSlug,
    IHotelWithOffers,
} from '../../common/common';
import {TOperatorById} from '../../hotel-page-flow/getHotelOffers/models';
import {
    IFilterInfo,
    ISortInfo,
    ESearchBannerType,
    ITimingInfo,
    ISearchControlInfo,
} from './models';

export interface IResponse {
    // Геопоисковый контекст.
    // Необходимо запомнить на фронте и использовать при следующем поисковом запросе.
    context: string;

    // Номера сессии и итерации поллинга.
    // Передаются из запроса без изменений.
    pollEpoch: number;
    pollIteration: number;

    /**
     * id итерации поиска на портале
     * он нужен для атрибуции и должен быть дописан в ссылки на выдаче.
     */
    searchPagePollingId?: string;

    /**
     * Имеются ли в выдаче BoY офера или нет
     */
    hasBoyOffers?: boolean;

    // Навигационные токены.
    navigationTokens: {
        // Токен, который необходимо передать бекенду для перехода на следующую страницу.
        nextPage: string;
        // Токен, который необходимо передать бекенду для перехода на предыдущую страницу.
        prevPage: string;
        // Токен, который необходимо передать бекенду для текущей страницы (сохраняется в url фронтом)
        currentPage: string;
    };

    // Ограничивающий прямоугольник для карты.
    // - Если пришел в запросе, то отдаем такой же; иначе вычисляем сами и отдаем фронту.
    bboxAsString: string; // 37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat
    // - Он же, но в виде списка.
    bboxAsStruct: ICoordinates[];

    /* Информация о фактически определенном регионе для шапки. "Екатеринбург"
     * @deprecated Должно быть выпилено после перехода на actualRegion
     */
    region: IGeoRegion;
    /* Информация о фактически определенном регионе для шапки.
     * Не содержит лингвистики, т.к может быть составным ("Москва, Бирюлёво" или даже "Тайланд и Вьетнам")
     * Не содержит geoId по тем же причинам
     */
    actualRegion: {
        name: string;
    };
    // Информация об изначальном регионе поиска, соответствует geoId из запроса
    searchRegion: IGeoRegion;
    // "Показать цены в X отелях"
    foundHotelCount: number; // X

    filterInfo: IFilterInfo;

    searchControlInfo: ISearchControlInfo;

    sortInfo: ISortInfo;

    offerSearchParams: IRequiredOfferSearchParams;
    offerSearchProgress: IOfferSearchProgress;
    nextPollingRequestDelayMs?: number; // Заполнено, если offerSearchProgress.finished == false. Минимальное значение - 200ms

    // Длина стабильного префикса списка отелей с ценами.
    pricedHotelCount: number;

    // Ранжированные отели.
    // Первые `pricedHotelCount` отелей можно использовать для отрисовки списка.
    // Передаются только обновления (!!!), подробнее - в README.md, в секции про поллинг
    hotels: IHotelWithOffers[];
    // Информация об операторах тоже передаётся в накопительном режиме
    operatorById: TOperatorById;

    // Если указано - нужно показать баннер соответствующего типа над поисковой выдачей
    searchBannerType?: ESearchBannerType;

    extraVisitAndUserParams: IExtraVisitAndUserParams;

    timingInfo: ITimingInfo;

    // Нужно пробросить в url и в следующие запросы (если null - убрать оттуда).
    topHotelSlug?: THotelSlug;
}
