import {EPlainTextStyle} from 'common/seo-pages/EPlainTextStyle';

import {EMainAmenityId} from '../../../hotel-page-flow/getHotelInfo/models';
import {ECurrencyType} from '../../../../common/common';
import {IResponse} from '../response';
import {EGeoRegionBlockType} from '../models';
import {ESectionBlock} from '../../../../common/seo-pages/ISectionTextBlock';

const geoRegionResponse: IResponse = {
    seoInfo: {
        title: 'Отели в Сочи',
        description: 'Отели в Сочи с кошками',
        openGraph: {
            title: 'openGraph название страницы',
            description: 'openGraph описание страницы',
            image: 'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
            imageSize: {
                height: 200,
                width: 200,
            },
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Кто в Москве не бывал',
                    answer: 'Красоты не видал.',
                },
                {
                    question: 'Ну Татарин!',
                    answer: 'Жизнь висит на нитке, а думает о прибытке.',
                },
            ],
        },
    },
    extraVisitAndUserParams: {
        visitParams: {
            hotels: {
                seoRegionPage: {
                    kind: 'city',
                    geoId: '239',
                },
            },
        },
    },
    blocks: [
        {
            type: EGeoRegionBlockType.SEARCH_FORM_BLOCK,
            data: {
                title: 'Отели в Сочи',
                imageUrl:
                    'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
                searchFormParams: {
                    isCalendarOpen: false,
                    regionSlug: 'moscow/',
                },
            },
        },
        {
            type: EGeoRegionBlockType.HOTELS_BLOCK,
            data: {
                title: 'Отели с кошками',
                searchButtonText: 'Все отели с кошками',
                searchParams: {},
                region: {
                    geoId: 213,
                    linguistics: {
                        nominativeCase: 'Москва',
                        genitiveCase: 'Москвы',
                        dativeCase: 'Москве',
                        prepositionalCase: 'Москве',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'Москву',
                        instrumentalCase: 'Москвой',
                    },
                    slug: 'moscow',
                },
                hotels: [
                    {
                        hotel: {
                            permalink: '1019057204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Marriott Grand Hotel',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 5,
                            rating: 5,
                            totalTextReviewCount: 315,
                            totalImageCount: 139,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/492546/2a0000015fdc1509311f2ce61d539f0187e4/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: EMainAmenityId.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: EMainAmenityId.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: EMainAmenityId.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: EMainAmenityId.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: EMainAmenityId.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: EMainAmenityId.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: EMainAmenityId.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                        },
                        minPrice: {
                            value: 2222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                    {
                        hotel: {
                            permalink: '1019fd057204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Grand',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 2,
                            rating: 4,
                            totalTextReviewCount: 100,
                            totalImageCount: 139,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/758053/2a00000161571db25bde344add504bfc30ac/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: EMainAmenityId.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: EMainAmenityId.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: EMainAmenityId.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: EMainAmenityId.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: EMainAmenityId.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: EMainAmenityId.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: EMainAmenityId.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                        },
                        minPrice: {
                            value: 232,
                            currency: ECurrencyType.RUB,
                        },
                    },
                ],
            },
        },
        {
            type: EGeoRegionBlockType.HOTELS_BLOCK,
            data: {
                title: 'Отели с собаками',
                searchButtonText: 'Все отели с собаками',
                searchParams: {},
                region: {
                    geoId: 213,
                    linguistics: {
                        nominativeCase: 'Москва',
                        genitiveCase: 'Москвы',
                        dativeCase: 'Москве',
                        prepositionalCase: 'Москве',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'Москву',
                        instrumentalCase: 'Москвой',
                    },
                    slug: 'moscow',
                },
                hotels: [
                    {
                        hotel: {
                            permalink: '101905723204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Hotel',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 5,
                            rating: 5,
                            totalTextReviewCount: 1315,
                            totalImageCount: 1393,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/1705560/2a0000016fd2d3f4342638607f57f9bf277c/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: EMainAmenityId.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: EMainAmenityId.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: EMainAmenityId.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: EMainAmenityId.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: EMainAmenityId.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: EMainAmenityId.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: EMainAmenityId.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                        },
                        minPrice: {
                            value: 123,
                            currency: ECurrencyType.RUB,
                        },
                    },
                    {
                        hotel: {
                            permalink: '101239fd057204',
                            hotelSlug: 'moscow/vega-izmailovo',
                            name: 'Gr',
                            category: {id: 'hotels', name: 'Гостиница'},
                            coordinates: {
                                lat: 55.768322,
                                lon: 37.599392,
                            },
                            address: 'Россия, Москва, Тверская улица, 26/1',
                            stars: 2,
                            rating: 4,
                            totalTextReviewCount: 100,
                            totalImageCount: 139,
                            images: [
                                {
                                    urlTemplate:
                                        'https://avatars.mds.yandex.net/get-altay/1974402/2a0000016fd2d3f671e330b8976184f08ac4/%s',
                                    id: 'urn:yandex:sprav:photo:7805558',
                                    sizes: [
                                        {
                                            size: 'XXXS',
                                            height: 32,
                                            width: 50,
                                        },
                                        {
                                            size: 'XXS',
                                            height: 48,
                                            width: 75,
                                        },
                                        {
                                            size: 'XS',
                                            height: 64,
                                            width: 100,
                                        },
                                        {size: 'S', height: 96, width: 150},
                                        {
                                            size: 'M',
                                            height: 192,
                                            width: 300,
                                        },
                                        {size: 'L', height: 319, width: 500},
                                        {
                                            size: 'XL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'XXL', height: 511, width: 800},
                                        {
                                            size: 'XXXL',
                                            height: 511,
                                            width: 800,
                                        },
                                        {size: 'orig', height: 511, width: 800},
                                    ],
                                    tags: ['Interior'],
                                },
                            ],
                            mainAmenities: [
                                {
                                    id: EMainAmenityId.WI_FI,
                                    name: 'Модем',
                                },
                                {
                                    id: EMainAmenityId.POOL,
                                    name: 'Можно пьяным в бассейн',
                                },
                                {
                                    id: EMainAmenityId.CAR_PARK,
                                    name: 'Парковка',
                                },
                                {
                                    id: EMainAmenityId.AIR_CONDITIONING,
                                    name: 'Прохладно там где надо',
                                },
                                {
                                    id: EMainAmenityId.GYM,
                                    name: 'На спортике',
                                },
                                {
                                    id: EMainAmenityId.PAYMENT_BY_CARD,
                                    name: 'Оплата картой',
                                },
                                {
                                    id: EMainAmenityId.BEACH_LINE,
                                    name: 'Ещё и пляж недалеко',
                                },
                            ],
                        },
                        minPrice: {
                            value: 99,
                            currency: ECurrencyType.RUB,
                        },
                    },
                ],
            },
        },
        {
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            data: {},
            children: [
                {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'Город? Город - страшная сила. А чем больше город, тем она сильнее. Он засасывает. Только сильный может выкарабкаться.',
                            },
                        },
                    ],
                },
            ],
        },
        {
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            data: {
                title: 'В Москве вся сила',
            },
            children: [
                {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'Город - ',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'злая ',
                                styles: [EPlainTextStyle.BOLD_STYLE],
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'сила. Сильный приезжает, становится ',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'слабым. ',
                                styles: [EPlainTextStyle.ITALIC_STYLE],
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'Город забирает силу. Вот и ты ',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'пропал.',
                                styles: [
                                    EPlainTextStyle.ITALIC_STYLE,
                                    EPlainTextStyle.BOLD_STYLE,
                                ],
                            },
                        },
                    ],
                },
                {
                    type: ESectionBlock.SUB_SECTION_TEXT_BLOCK,
                    data: {
                        title: 'Ты тут разгребай и в Москву',
                    },
                    children: [
                        {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'В общем, дело непростое. Ты присмотрись, подумай, как уйти. А денег я лучше тебе дам. ',
                                    },
                                },
                                {
                                    type: ESectionBlock.PRICE_TEXT_BLOCK,
                                    data: {
                                        price: {
                                            currency: ECurrencyType.USD,
                                            value: 2000,
                                        },
                                    },
                                },
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: ' баксов. Ко мне больше не ходи - опасно. Вот тебе ствол с обоймой. Это еще шестьсот.',
                                    },
                                },
                            ],
                        },
                    ],
                },
                {
                    type: ESectionBlock.SUB_SECTION_TEXT_BLOCK,
                    data: {
                        title: 'Не Ленинград, а Петербург',
                    },
                    children: [
                        {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.REGION_LINK_BLOCK,
                                    data: {
                                        text: 'Питер. ',
                                        urlParams: {
                                            regionSlug: 'piter',
                                        },
                                    },
                                },
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Красивый город, но провинция. Слушай, Немец, мне комнатка нужна маленькая в ',
                                    },
                                },
                                {
                                    type: ESectionBlock.SEARCH_HOTELS_LINK_BLOCK,
                                    data: {
                                        text: 'центре',
                                        urlParams: {},
                                    },
                                },
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: ', чтобы тихо было.',
                                    },
                                },
                            ],
                        },
                    ],
                },
                {
                    type: ESectionBlock.SUB_SECTION_TEXT_BLOCK,
                    data: {
                        title: 'Там Шевчук, Кинчев, Настя - все',
                    },
                    children: [
                        {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'А это что? - Это ',
                                    },
                                },
                                {
                                    type: ESectionBlock.EXTERNAL_LINK_BLOCK,
                                    data: {
                                        text: 'Наутилуса ',
                                        url: 'https://ru.wikipedia.org/wiki/Наутилус_(группа)',
                                    },
                                },
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'концерт. Юбилейный. Очень редкий. Я достал.',
                                    },
                                },
                            ],
                        },
                    ],
                },
                {
                    type: ESectionBlock.SUB_SECTION_TEXT_BLOCK,
                    data: {
                        title: 'Выручай, брат!',
                    },
                    children: [
                        {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Надо срочно подъехать и разобраться вместо меня. Да, сразу за ',
                                    },
                                },
                                {
                                    type: ESectionBlock.HOTEL_LINK_BLOCK,
                                    data: {
                                        text: 'гостиницей "Прибалтийская" ',
                                        urlParams: {
                                            hotelSlug:
                                                'saint-petersburg/park-inn-by-radisson-pribaltiyskaya/',
                                        },
                                    },
                                },
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'на Васильевском, в пять. Будет стоять "Вольво", там двое парней, они всё растолкуют.',
                                    },
                                },
                            ],
                        },
                    ],
                },
            ],
        },
        {
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            data: {
                title: 'А едешь-то куда? В Москву!',
            },
            children: [
                {
                    type: ESectionBlock.SPOILER_BLOCK,
                    data: {
                        title: 'Кто в Москве не бывал',
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Красоты не видал.',
                                    },
                                },
                            ],
                        },
                    },
                },
                {
                    type: ESectionBlock.SPOILER_BLOCK,
                    data: {
                        title: 'Ну Татарин!',
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Жизнь висит на нитке, а думает о прибытке.',
                                    },
                                },
                            ],
                        },
                    },
                },
                {
                    type: ESectionBlock.SPOILER_BLOCK,
                    data: {
                        title: 'Это был не Татарин, а молодой. Всё классно сделал.',
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Профессионал.',
                                    },
                                },
                            ],
                        },
                    },
                },
            ],
        },
        {
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            data: {
                title: 'Ну что могу предложить, господа?',
            },
            children: [
                {
                    type: ESectionBlock.GEO_LINK_GROUP_BLOCK,
                    data: {
                        mainLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Тульский Токарев',
                                urlParams: {
                                    regionSlug: 'tokarev',
                                },
                            },
                        },
                        additionalLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'TT',
                                urlParams: {
                                    regionSlug: 'tt',
                                },
                            },
                        },
                    },
                },
                {
                    type: ESectionBlock.GEO_LINK_GROUP_BLOCK,
                    data: {
                        mainLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'ППШ',
                                urlParams: {
                                    regionSlug: 'ppsh',
                                },
                            },
                        },
                        additionalLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Машина тяжелая, но убойная',
                                urlParams: {
                                    regionSlug: 'ppsh',
                                },
                            },
                        },
                    },
                },
                {
                    type: ESectionBlock.GEO_LINK_GROUP_BLOCK,
                    data: {
                        mainLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Гранаты',
                                urlParams: {
                                    regionSlug: 'grenades',
                                },
                            },
                        },
                        additionalLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Примерно 50 на 50',
                                urlParams: {
                                    regionSlug: 'grenades',
                                },
                            },
                        },
                    },
                },
                {
                    type: ESectionBlock.GEO_LINK_GROUP_BLOCK,
                    data: {
                        mainLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Вальтер',
                                urlParams: {
                                    regionSlug: 'walter',
                                },
                            },
                        },
                        additionalLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Импортное',
                                urlParams: {
                                    regionSlug: 'walter',
                                },
                            },
                        },
                    },
                },
                {
                    type: ESectionBlock.GEO_LINK_GROUP_BLOCK,
                    data: {
                        mainLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Фауст патроны',
                                urlParams: {
                                    regionSlug: 'faust',
                                },
                            },
                        },
                        additionalLink: {
                            type: ESectionBlock.REGION_LINK_BLOCK,
                            data: {
                                text: 'Эхо войны',
                                urlParams: {
                                    regionSlug: 'faust',
                                },
                            },
                        },
                    },
                },
            ],
        },
    ],
};

export default geoRegionResponse;
