import {ICrossSaleHotelsBlock} from 'common/seo-pages/ICrossSaleHotelsBlock';
import {IPrice} from 'common/common';
import {ISeoInfo} from 'common/seo-pages/ISeoInfo';
import {IFAQSchemaMarkupItem} from 'common/seo-pages/IFAQSchemaMarkupItem';

import {
    TGeoId,
    IBreadcrumbs,
    TGeoRegionSlug,
    IBadge,
    IGeoRegion,
} from '../../common/common';
import {IHotel} from '../../hotel-page-flow/getHotelInfo/models';
import {
    IFilterInfo,
    IFilterParams,
    TSortId,
} from '../../search-flow/searchHotels/models';
import {ISectionTextBlock} from '../../../common/seo-pages/ISectionTextBlock';

/**
 * Slug фильтра (id фильтра, который задаётся в URL'ах)
 * Префикс "filter-" в slug не входит
 * @example "https://travel.yandex.ru/hotels/yekaterinburg/filter-pool"
 * Здесь filterSlug = "pool"
 */
export type TFilterSlug = string;

export interface IGeoRegionSeoInfo extends ISeoInfo<IGeoRegionSchemaOrgInfo> {}

export interface IGeoRegionSchemaOrgInfo {
    faqItems?: IFAQSchemaMarkupItem[];
}

/**
 * Блок для отрисковки формы поиска
 */
export interface ISearchFormBlock {
    type: EGeoRegionBlockType.SEARCH_FORM_BLOCK;
    data: {
        /**
         * Ссылка на картинку для формы
         */
        imageUrl: string;
        /**
         * Заголовок над формой
         */
        title: string;
        /**
         * Параметры для отрисовки формы
         */
        searchFormParams: {
            /**
             * regionSlug для предзаполнения саджеста и возможно редиректа при смене regionSlug в базе
             */
            regionSlug: TGeoRegionSlug;
            /**
             * Открывать ли календарик по дефолту
             */
            isCalendarOpen: boolean;
        };
        /**
         * Фильтры, которые нужно применить при переходе на страницу поиска
         */
        filterParams?: IFilterParams;
    };
}

/**
 * Блок для отрисовки Breadcrumbs
 */
export interface IBreadcrumbsBlock {
    type: EGeoRegionBlockType.BREADCRUMBS_BLOCK;
    data: {
        breadcrumbs: IBreadcrumbs;
    };
}

/**
 * Блок для отрисковки групп отелей
 */
export interface IHotelsBlock {
    type: EGeoRegionBlockType.HOTELS_BLOCK;
    data: {
        /**
         * Заголовок группы отелей
         */
        title: string;
        /**
         * Список отелей
         */
        hotels: IHotelWithMinPrice[];
        /**
         * Текст кнопки для перехода на поиск
         */
        searchButtonText: string;
        /**
         * Параметры для формирования ссылки на страницу поиска
         */
        searchParams: ISearchPageIdentifyParams;
        /**
         * Информация о регионе отеля (склонения, slug)
         */
        region: IGeoRegion;
    };
}

/**
 * Блок фильтров
 */
export interface IHotelsFiltersBlock {
    type: EGeoRegionBlockType.HOTELS_FILTERS_BLOCK;
    data: {
        /**
         * Данные для построения фильтров
         */
        filterInfo: IFilterInfo;
        /**
         * Параметры для формирования ссылки на страницу поиска
         */
        searchParams: ISearchPageIdentifyParams;
    };
}

/**
 * Отель со средней ценой
 */

export interface IHotelWithMinPrice {
    /** Параметры отеля */
    hotel: IHotel;
    /** Минимальная цена за количество ночей = nights */
    minPrice: IPrice;
    /** Количество ночей. Если отсутствует то считаем, что цена за 1 ночь */
    nights?: number;
    /** Бэджики отеля */
    badges?: IBadge[];
    /** Признак: участвует ли отель в программе кэшбэка от Яндекс.Плюс **/
    hasOfferYandexPlus?: boolean;
}

/**
 * Параметры для формирования ссылки на страницу поиска
 */

export interface ISearchPageIdentifyParams {
    /**
     * geoId региона
     */
    geoId?: TGeoId;
    /**
     * Выбранный тип сортировки
     */
    selectedSortId?: TSortId;
    /**
     * Параметры фильтров с searchText
     */
    filterParams?: IFilterParams;
}

/**
 * Ссылка на страницу региона, саму ссылку формирует фронт
 */

export interface IRegionLinkBlock {
    type: EGeoRegionBlockType.REGION_LINK_BLOCK;
    data: {
        /**
         * Текст ссылки
         */
        text: string;
        /**
         * Параметры для формирования ссылки
         */
        urlParams: {
            regionSlug: TGeoRegionSlug;
            filterSlug?: TFilterSlug;
        };
    };
}

/**
 * Блок ссылок на страницы региона с фильтрами. Отображается на странице региона без фильтра
 * На десктопе располагается в левой части
 */
interface IRegionLinkSetBlock {
    type: EGeoRegionBlockType.REGION_LINK_SET_BLOCK;
    data: {
        /**
         * Заголовок h2
         */
        title: string;
        /**
         * Массив подгрупп ссылок. Не пустой
         */
        subsets: IRegionLinkSubSetBlock[];
    };
}

interface IRegionLinkSubSetBlock {
    type: EGeoRegionBlockType.REGION_LINK_SUB_SET_BLOCK;
    data: {
        /**
         * Заголовок h3
         */
        title: string;
        /**
         * Массив ссылок. Не пустой
         */
        links: IRegionLinkBlock[];
    };
}

/**
 * Верхнеуровневые блоки
 */
export type TGeoRegionBlock =
    | ISearchFormBlock
    | IBreadcrumbsBlock
    | IHotelsBlock
    | IHotelsFiltersBlock
    | ISectionTextBlock
    | IRegionLinkSetBlock
    | ICrossSaleHotelsBlock;

/**
 * Все возможные типы блоков от самых больших - до самых маленьких
 */
export enum EGeoRegionBlockType {
    SEARCH_FORM_BLOCK = 'ISearchFormBlock',
    BREADCRUMBS_BLOCK = 'IBreadcrumbsBlock',
    HOTELS_BLOCK = 'IHotelsBlock',
    HOTELS_FILTERS_BLOCK = 'IHotelsFiltersBlock',
    REGION_LINK_BLOCK = 'IRegionLinkBlock',
    REGION_LINK_SET_BLOCK = 'IRegionLinkSetBlock',
    REGION_LINK_SUB_SET_BLOCK = 'IRegionLinkSubSetBlock',
}
