/**
 * Запрос для логирования саджеста, выбранного пользователем
 */
export interface IRequest {
    /**
     * Флаг, обозначающий, что саггест выбран мануально,
     * те клик или ентер
     */
    isManualClick: boolean;

    // TODO: удалить после выкатки фронт+бек (поле переименовано в isManualClick)
    isUserInput: boolean;

    /**
     * Флаг, обозначающий, что саггест выбран человеком, а не роботом
     */
    isTrustedUser: boolean;

    /**
     * Идентификатор саджеста, выбранный пользователем
     */
    selectedId: string;

    /**
     * Идентификатор сессии для логов
     */
    sessionId: string;

    /**
     * Порядковый номер запроса для логов
     */
    requestIndex: number;
}
