import {
    IHotelIdentifier,
    IRegionIdentifier,
    TPermalink,
    THotelSlug,
    EGeoLocationStatus,
} from '../../common/common';

export interface IRequest extends IHotelIdentifier, Partial<IRegionIdentifier> {
    /**
     * Запрос пользователя
     */
    query?: string;

    /**
     * Пермалинк отеля
     */
    permalink?: TPermalink;

    /**
     * Slug отеля
     */
    hotel_slug?: THotelSlug;

    /**
     * Максимальное количество подсказок во всем саджесте
     */
    limit: number;

    /**
     * Путь страницы, с которой был отправлен запрос
     * window.location.pathname, например '/hotels/kazan'
     */
    pathname: string;

    /**
     * Язык саджеста
     * Возможные значения: ru, en, tr.
     */
    language: string;

    /**
     * Геополитический домен
     *
     * @example 'ru'
     */
    domain: string;

    /**
     * Идентификатор сессии для логов
     */
    sessionId: string;

    /**
     * Порядковый номер запроса для логов
     */
    requestIndex: number;

    geoLocationStatus: EGeoLocationStatus;

    /**
     * Обязательно передаётся, если geoLocationStatus==available
     */
    userCoordinates?: string; // userCoordinates=37.0408809,55.311850; // lon,lat
}
