import {
    TPermalink,
    TGeoId,
    THotelSlug,
    TOptionalOfferSearchParams,
} from '../../common/common';

/**
 * В теле ответа содержится массив ISuggestGroup
 */
export interface IResponse {
    groups: ISuggestGroup[];
}

export interface ISuggestGroup {
    /**
     * Имя группы для отображения
     */
    name?: string;

    /**
     * Саджесты группы
     */
    items: ISuggestItem[];
}

export interface ISuggestItem {
    /**
     * Идентификатор саджеста для логирования
     */
    id: string;

    /**
     * Имя саджеста
     */
    name: string;

    /**
     * Описание саджеста
     */
    description?: string;

    /**
     * Параметры перехода по саджесту
     */
    redirectParams: {
        /**
         * Тип саджеста
         */
        type:
            | 'region'
            | 'hotel'
            | 'hotels_nearby'
            | 'history'
            | 'cross_sale'
            | 'cross_search';

        /**
         * id региона
         */
        geoId?: TGeoId;

        /** Пермалинк */
        permalink?: TPermalink;
        /** Главный slug отеля. */
        hotelSlug?: THotelSlug;

        selectedSortId?: string;

        /**
         * Центр сортировки
         * lon,lat (например 37.0408809,55.311850)
         */
        sortOrigin?: string;

        bbox?: string; // lon,lat~lon,lat

        offerSearchParams?: TOptionalOfferSearchParams;
    };
}
