import {TDate} from 'common/common';
import {TSlug} from 'common/PointKey';

enum EBannerType {
    YA_TRAVEL_HOTELS = 'yaTravelHotels',
    BLA_BLA_CAR = 'bla_bla_car',
    ADVERTISING = 'advertising',
}

interface IBaseBanner {
    bannerType: EBannerType;
    data: unknown;
}

interface IBlaBlaCarBannerInfo extends IBaseBanner {
    bannerType: EBannerType.BLA_BLA_CAR;
    data: null;
}

interface IAdvertisingBannerInfo extends IBaseBanner {
    bannerType: EBannerType.ADVERTISING;
    data: null;
}

interface IHotelsBannerInfo extends IBaseBanner {
    bannerType: EBannerType.YA_TRAVEL_HOTELS;
    data: {
        geoId: number;
        slug: TSlug;
        region: string;
        checkinDate?: TDate;
        /**
         * Флаг того можно с данных слагом вести на страницу региона,
         * или можно вести только на поиск
         */
        doesLandingExist: boolean;
    };
}

export type TBannerInfo =
    | IHotelsBannerInfo
    | IBlaBlaCarBannerInfo
    | IAdvertisingBannerInfo;
