import {TDate} from 'common/common';

import {
    EFilterTransportType,
    ENationalVersion,
    EDateSpecialValue,
    TPoint,
} from './models/common';

/**
 * Ручки поиска на расписаниях
 *
 * @url testing.morda-backend.rasp.yandex.net/<language>/search/search
 * @url morda-backend.rasp.yandex.net/<language>/search/search
 */
export interface IRequest {
    pointFrom: TPoint;
    pointTo: TPoint;
    nationalVersion: ENationalVersion;
    nearest: boolean;
    group_trains?: boolean;
    isMobile?: boolean;
    allowChangeContext?: boolean;
    busSettlementKeys: boolean;
    /** Пока бэкенд возвращает отмены только с этим параметром для обратной совместимости */
    disable_cancels: false;
    /** @example [ 'Europe/Moscow' ] */
    timezones?: string[];
    transportType?: EFilterTransportType;
    when?: TDate | EDateSpecialValue;
}
