import {TDate, TInstantDateTime} from 'common/common';
import {TSlug} from 'common/PointKey';

import {ISegmentFromBackend} from './models/segments';
import {TBannerInfo} from './models/bannerInfo';
import {ETransportType, TPoint} from './models/common';
import {ISearchResponseDirection} from './models/direction';

export interface IResponse {
    plans: {
        current: {
            startDate: TDate;
            code: TPoint;
            endDate: TDate;
            title: string;
        };
        next: unknown | null;
    };
    teasers: object;
    segments: ISegmentFromBackend[];
    context: {
        transportTypes: ETransportType[];
        search: {
            nearest: boolean;
            pointTo: ISearchResponseDirection;
            pointFrom: ISearchResponseDirection;
        };
        latestDatetime: TInstantDateTime;
        isChanged: boolean;
        original: {
            nearest: boolean;
            pointTo: ISearchResponseDirection;
            pointFrom: ISearchResponseDirection;
        };
    };
    archivalData: unknown | null;
    canonical: {
        transportType: unknown | null;
        pointTo: TSlug;
        pointFrom: TSlug;
    };

    bannerInfo?: TBannerInfo;
}
