import {IHotel} from '../../../models/hotels';
import {
    IHotelFilterParams,
    IHotelPageNavigationParams,
    IHotelSortParams,
} from '../../../models/search-hotels';
import {IHotelAvailableSearchParams} from '../../../models/hotel-available-search-params';

export interface IResponse {
    /**
     * Параметры фильтрация.
     */
    filterParams: IHotelFilterParams;

    /**
     * Сортировки.
     */
    sortParams: IHotelSortParams;

    /**
     * Параметры пайджирования.
     */
    pageNavigationParams: IHotelPageNavigationParams;

    /**
     * Доступные фильтры и сортировки для поиска отелей.
     */
    availableSearchParams: IHotelAvailableSearchParams;

    /**
     * Список отелей.
     */
    hotels: IHotel[];

    /**
     * Общее число отелей.
     */
    hotelCount: number;
}
