import {IAsyncResponse} from '../../../models/hotel-async';
import {
    IHotelFilterParams,
    IHotelPageNavigationParams,
    IHotelPriceFilterParams,
    IHotelSortParams,
} from '../../../models/search-hotels';
import {IHotelWithDefaultOffer} from '../../../models/hotels';
import {IBookingParams} from '../../../models/hotel-offers';
import {IHotelAvailableSearchParams} from '../../../models/hotel-available-search-params';

export interface IResponse extends IAsyncResponse {
    /**
     * Параметры бронирования отелей.
     */
    bookingParams: IBookingParams;

    /**
     * Количество ночей, в заказанном бронировании.
     */
    nightsCount: number;

    /**
     * Доступные фильтры и сортировки для поиска отелей.
     */
    availableSearchParams: IHotelAvailableSearchParams;

    /**
     * Параметры фильтрация.
     */
    filterParams: IHotelFilterParams;

    /**
     * Фильтрация по ценам.
     */
    priceFilterParams: IHotelPriceFilterParams;

    /**
     * Параметры пайджирования.
     */
    pageNavigationParams: IHotelPageNavigationParams;

    /**
     * Сортировки.
     */
    sortParams: IHotelSortParams;

    /**
     * Отели с лучшей ценой на номер.
     */
    hotels: IHotelWithDefaultOffer[];

    /**
     * Число отелей удовлетворяющих
     */
    hotelCount: number;
}
