export interface IHotelAmenitiesGroup {
    /**
     * Id. Машино-читаемая строка.
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * @example "Услуги и удобства"
     */
    name: string;

    /**
     * Удобства группы
     */
    amenities: IHotelAmenity[];
}

export interface IHotelAmenity {
    /**
     * Id. Машино-читаемая строка
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * Пример: "химчистка", "душ", "парковка".
     */
    name: string;

    /**
     * Свойство зачеркнуто.
     */
    isStrikethrough?: boolean;
}
