export interface IAsyncParams {
    /**
     * Номер сессии поллинга фронта (для отладки и аналитики).
     */
    pollEpoch: number;
    /**
     * Номер итерации поллинга фронта (для отладки и аналитики).
     */
    pollIteration: number;
    /**
     * Идентификатор поиска на бэкенде.
     */
    pollingId?: string;
}

export interface IAsyncResponse {
    /**
     * Номер сессии поллинга фронта (для отладки и аналитики).
     * Копируем из запроса.
     */
    pollEpoch: number;
    /**
     * Номер итерации поллинга фронта (для отладки и аналитики).
     * Копируем из запроса.
     */
    pollIteration: number;
    /**
     * Идентификатор поиска на бэкенде.
     * Копируем из запроса, если не передан с фронта.
     */
    pollingId: string;
}
