import {TSortId} from './search-hotels';

export interface IHotelAvailableSearchParams {
    /**
     * Свойства отеля по которым фильтруем.
     */
    amenityFilters: IHotelAmenityFilter[];

    /**
     * Географические положения отеля по которым фильтруем.
     */
    geoFilters: IHotelGeoFeatureFilter[];

    /**
     * Список сортировок.
     */
    sorts: IHotelSort[];
}

export interface IHotelGeoFeatureFilter {
    /**
     * Id. Машино-читаемая строка.
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * @example "Расстояние до центра города"
     */
    name: string;

    /**
     * Возможные значения в группе.
     */
    options: IHotelGeoFeatureFilterOption[];
}

export interface IHotelGeoFeatureFilterOption {
    /**
     * Id. Машино-читаемая строка.
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * @example "1 км."
     */
    name: string;
}

export interface IHotelGeoFeatureFilter {
    /**
     * Id. Машино-читаемая строка.
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * @example "Расстояние до центра города"
     */
    name: string;

    /**
     * Возможные значения в группе.
     */
    options: IHotelGeoFeatureFilterOption[];
}

export interface IHotelGeoFeatureFilterOption {
    /**
     * Id. Машино-читаемая строка.
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * @example "1 км."
     */
    name: string;
}

export interface IHotelAmenityFilter {
    /**
     * Id. Машино-читаемая строка
     */
    id: string;

    /**
     * Код иконки.
     */
    iconCode?: string;

    /**
     * Человеко-читаемое название. Для отрисовки.
     * Пример: "химчистка", "душ", "парковка".
     */
    name: string;
}

export interface IHotelSort {
    /**
     * Идентификатор сортировки.
     */
    sortId: TSortId;

    /**
     * Названия сортировки.
     */
    sortTitle: string;

    /**
     * Нужен центр сортировки.
     */
    sortDistance: boolean;
}
